# Copyright (C) 2013-2023 Echelon Corporation.  All Rights Reserved.
# Use of this code is subject to your compliance with the terms of the
# Echelon IzoT(tm) Software Developer's Kit License Agreement which is
# available at www.echelon.com/license/izot_sdk/.

# IzoT resources contained in this file are generated by an automated
# database to source code conversion process.  Grammar and punctuation within
# the embedded documentation may not be correct, as this data is gathered and
# combined from several sources.
# Names of resources and fields or members defined within a resource are
# derived from the same sources.  Names, capitalization and aspects of source
# code formatting may fail to comply with PEP-8 and PEP-257 recommendations
# due to the automated generation of these IzoT definitions.
# Generated at 11-May-2023 17:11.

"""FmkSetup userdefined datapoint type, originally defined in resource file
set apollodev 90:00:01:06:00:00:00:00-4.  """


import izot.resources.base
from P9000010600000000_4.userdefined import userdefined
import P9000010600000000_4.enumerations.pass_t


class FmkSetup(izot.resources.base.Structure):
    """FmkSetup userdefined datapoint type.  Scaling data."""

    class alarmType(izot.resources.base.Structure):

        def __init__(self):
            super().__init__(
                key=-1,
                scope=-1
            )

            self.__ena = izot.resources.base.Array(
                [
                    izot.resources.base.Scaled(
                        size=1,
                        signed=False,
                        minimum=0,
                        maximum=255
                    ) for i in range(2)
                ]
            )
            self._register(('ena', self.__ena))

            self.__lev = izot.resources.base.Array(
                [
                    izot.resources.base.Scaled(
                        size=2,
                        signed=False,
                        minimum=0,
                        maximum=65535
                    ) for i in range(2)
                ]
            )
            self._register(('lev', self.__lev))

            self.__lat = izot.resources.base.Array(
                [
                    izot.resources.base.Scaled(
                        size=1,
                        signed=False,
                        minimum=0,
                        maximum=255
                    ) for i in range(2)
                ]
            )
            self._register(('lat', self.__lat))

            self.__trig = izot.resources.base.Array(
                [
                    izot.resources.base.Scaled(
                        size=1,
                        signed=False,
                        minimum=0,
                        maximum=255
                    ) for i in range(2)
                ]
            )
            self._register(('trig', self.__trig))

        def __set_ena(self, v):
            self.__ena._value = v

        ena = property(
            lambda self: self.__ena._value,
            __set_ena,
            None,
            """."""
        )

        def __set_lev(self, v):
            self.__lev._value = v

        lev = property(
            lambda self: self.__lev._value,
            __set_lev,
            None,
            """."""
        )

        def __set_lat(self, v):
            self.__lat._value = v

        lat = property(
            lambda self: self.__lat._value,
            __set_lat,
            None,
            """."""
        )

        def __set_trig(self, v):
            self.__trig._value = v

        trig = property(
            lambda self: self.__trig._value,
            __set_trig,
            None,
            """."""
        )

        def __len__(self):
            """Return the length of the type, in bytes."""
            return 10

    def __init__(self):
        super().__init__(
            key=5,
            scope=4
        )

        self.__location = izot.resources.base.Array(
            [
                izot.resources.base.Scaled(
                    size=1,
                    signed=True,
                    minimum=-128,
                    maximum=127
                ) for i in range(14)
            ]
        )
        self._register(('location', self.__location))

        self.__alarm = FmkSetup.alarmType(
        )
        self._register(('alarm', self.__alarm))

        self.__security = P9000010600000000_4.enumerations.pass_t.pass_t(
        )
        self._register(('security', self.__security))

        self.__pass_ = izot.resources.base.Array(
            [
                izot.resources.base.Scaled(
                    size=1,
                    signed=True,
                    minimum=-128,
                    maximum=127
                ) for i in range(4)
            ]
        )
        self._register(('pass_', self.__pass_))
        self._original_name = 'UNVT_FmkSetup'
        self._definition = userdefined.add(self)


    def __set_location(self, v):
        self.__location._value = v

    location = property(
        lambda self: self.__location._value,
        __set_location,
        None,
        """."""
    )

    def __set_alarm(self, v):
        self.__alarm._value = v

    alarm = property(
        lambda self: self.__alarm._value,
        __set_alarm,
        None,
        """."""
    )

    def __set_security(self, v):
        self.__security._value = v

    security = property(
        lambda self: self.__security._value,
        __set_security,
        None,
        """."""
    )

    def __set_pass_(self, v):
        self.__pass_._value = v

    pass_ = property(
        lambda self: self.__pass_._value,
        __set_pass_,
        None,
        """."""
    )

    def __len__(self):
        """Return the length of the type, in bytes."""
        return 29


if __name__ == '__main__':
    # unit test code.
    item = FmkSetup()
    pass
